% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferCNV_heatmap.R
\name{plot_cnv}
\alias{plot_cnv}
\title{Plot the matrix as a heatmap, with cells as rows and genes as columns, ordered according to chromosome}
\usage{
plot_cnv(
  infercnv_obj,
  out_dir = ".",
  title = "inferCNV",
  obs_title = "Observations (Cells)",
  ref_title = "References (Cells)",
  cluster_by_groups = TRUE,
  cluster_references = TRUE,
  plot_chr_scale = FALSE,
  chr_lengths = NULL,
  k_obs_groups = 1,
  contig_cex = 1,
  x.center = mean(infercnv_obj@expr.data),
  x.range = "auto",
  hclust_method = "ward.D",
  custom_color_pal = NULL,
  color_safe_pal = FALSE,
  output_filename = "infercnv",
  output_format = "png",
  png_res = 300,
  dynamic_resize = 0,
  ref_contig = NULL,
  write_expr_matrix = FALSE,
  write_phylo = FALSE,
  useRaster = TRUE
)
}
\arguments{
\item{infercnv_obj}{infercnv object}

\item{out_dir}{Directory in which to save pdf and other output.}

\item{title}{Plot title.}

\item{obs_title}{Title for the observations matrix.}

\item{ref_title}{Title for the reference matrix.}

\item{cluster_by_groups}{Whether to cluster observations by their annotations or not. Using this ignores k_obs_groups.}

\item{cluster_references}{Whether to cluster references within their annotations or not. (dendrogram not displayed)}

\item{plot_chr_scale}{Whether to scale the chromosme width on the heatmap based on their actual size rather than just the number of expressed genes.}

\item{chr_lengths}{A named list of chromsomes lengths to use when plot_chr_scale=TRUE, or else chromosome size is assumed to be the last chromosome's stop position + 10k bp}

\item{k_obs_groups}{Number of groups to break observation into.}

\item{contig_cex}{Contig text size.}

\item{x.center}{Value on which to center expression.}

\item{x.range}{vector containing the extreme values in the heatmap (ie. c(-3,4) )}

\item{hclust_method}{Clustering method to use for hclust.}

\item{custom_color_pal}{Specify a custom set of colors for the heatmap. 
Has to be in the shape color.palette(c("darkblue", "white", "darkred"),
                                     c(2, 2))}

\item{color_safe_pal}{Logical indication of using a color blindness safe palette.}

\item{output_filename}{Filename to save the figure to.}

\item{output_format}{format for heatmap image file (default: 'png'), options('png', 'pdf', NA)
If set to NA, will print graphics natively}

\item{png_res}{Resolution for png output.}

\item{dynamic_resize}{Factor (>= 0) by which to scale the dynamic resize of the observation 
heatmap and the overall plot based on how many cells there are.
Default is 0, which disables the scaling. Try 1 first if you want to enable.}

\item{ref_contig}{If given, will focus cluster on only genes in this contig.}

\item{write_expr_matrix}{Includes writing a matrix file containing the expression data that is plotted in the heatmap.}

\item{write_phylo}{Write newick strings of the dendrograms displayed on the left side of the heatmap to file.}

\item{useRaster}{Whether to use rasterization for drawing heatmap. Only disable if it produces an error as it is much faster than not using it.}
}
\value{
A list of all relevent settings used for the plotting to be able to reuse them in another plot call while keeping consistant plotting settings, most importantly x.range.
}
\description{
Formats the data and sends it for plotting.
}
\examples{
# data(infercnv_data_example)
# data(infercnv_annots_example)
# data(infercnv_genes_example)

# infercnv_object_example <- infercnv::CreateInfercnvObject(raw_counts_matrix=infercnv_data_example, 
#                                                           gene_order_file=infercnv_genes_example,
#                                                           annotations_file=infercnv_annots_example,
#                                                           ref_group_names=c("normal"))

# infercnv_object_example <- infercnv::run(infercnv_object_example,
#                                          cutoff=1,
#                                          out_dir=tempfile(), 
#                                          cluster_by_groups=TRUE, 
#                                          denoise=TRUE,
#                                          HMM=FALSE,
#                                          num_threads=2,
#                                          no_plot=TRUE)

data(infercnv_object_example)

plot_cnv(infercnv_object_example,
         out_dir=tempfile(),
         obs_title="Observations (Cells)",
         ref_title="References (Cells)",
         cluster_by_groups=TRUE,
         x.center=1,
         x.range="auto",
         hclust_method='ward.D',
         color_safe_pal=FALSE,
         output_filename="infercnv",
         output_format="png",
         png_res=300,
         dynamic_resize=0
         )

}
