% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise_reduction.R
\name{apply_median_filtering}
\alias{apply_median_filtering}
\title{apply_median_filtering}
\usage{
apply_median_filtering(
  infercnv_obj,
  window_size = 7,
  on_observations = TRUE,
  on_references = TRUE
)
}
\arguments{
\item{infercnv_obj}{infercnv_object}

\item{window_size}{Size of the window side centered on the data point to filter (default = 7).}

\item{on_observations}{boolean (default=TRUE), run on observations data (tumor cells).}

\item{on_references}{boolean (default=TRUE), run on references (normal cells).}
}
\value{
infercnv_obj with median filtering applied to observations
}
\description{
Apply a median filtering to the expression matrix within each tumor bounds
}
\examples{
# data(infercnv_data_example)
# data(infercnv_annots_example)
# data(infercnv_genes_example)

# infercnv_object_example <- infercnv::CreateInfercnvObject(raw_counts_matrix=infercnv_data_example, 
#                                                           gene_order_file=infercnv_genes_example,
#                                                           annotations_file=infercnv_annots_example,
#                                                           ref_group_names=c("normal"))

# infercnv_object_example <- infercnv::run(infercnv_object_example,
#                                          cutoff=1,
#                                          out_dir=tempfile(), 
#                                          cluster_by_groups=TRUE, 
#                                          denoise=TRUE,
#                                          HMM=FALSE,
#                                          num_threads=2,
#                                          no_plot=TRUE)

data(infercnv_object_example)

infercnv_object_example <- infercnv::apply_median_filtering(infercnv_object_example)
# plot result object

}
