% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainIMGT.R
\name{loadIMGT}
\alias{loadIMGT}
\title{Load Cached IMGT/HLA Sequences}
\usage{
loadIMGT(
  species = "human",
  gene,
  type = c("NUC", "PROT"),
  suppressMessages = FALSE
)
}
\arguments{
\item{species}{The species for which to download data. Required for TCR/BCR queries.
Currently supported: "human", "mouse", "rat", "rabbit", "pig", "dog", "rhesus_monkey", "cyno monkey". Defaults to "human" for HLA.}

\item{gene}{The gene or locus to download. For TCR/BCR, this can be a specific
chain (e.g., "IGHV", "TRBJ") or a group (e.g., "IGH", "TCR"). For HLA, use "HLA".}

\item{type}{The type of sequence to retrieve. Either "NUC" for nucleotide or
"PROT" for protein sequences. This primarily distinguishes between VDJ nucleotide
and V-region amino acid sequences for TCR/BCR genes.}

\item{suppressMessages}{Logical. If `TRUE`, suppresses the license and other
informational messages.}
}
\value{
A `DNAStringSet` or `AAStringSet` object.
}
\description{
Loads sequences from the local cache without attempting to download.
This function relies on `getIMGT(refresh = FALSE)`. If the data is not found
in the cache, it will be downloaded unless an internet connection is unavailable.
}
\examples{
if(is_imgt_available()) {
  # First, download a file to ensure it's in the cache
  getIMGT(species = "human", gene = "IGHV", type = "NUC", suppressMessages = TRUE)
  # Now, load it from the cache
  ighv_cached <- loadIMGT(species = "human", gene = "IGHV", type = "NUC")
}
}
