% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{loadBedTrack}
\alias{loadBedTrack}
\title{load a bed track provided as a data.frame}
\usage{
loadBedTrack(
  session,
  id,
  trackName,
  tbl,
  color = "",
  trackHeight = 50,
  deleteTracksOfSameName = TRUE,
  quiet = TRUE
)
}
\arguments{
\item{session}{an environment or list, provided and managed by shiny}

\item{id}{character string, the html element id of this widget instance}

\item{trackName}{character string}

\item{tbl}{data.frame, with at least "chrom" "start" "end" columns}

\item{color}{character string, a legal CSS color, or "random", 
"gray" by default}

\item{trackHeight}{an integer, 50 (pixels) by default}

\item{deleteTracksOfSameName}{logical, default TRUE}

\item{quiet}{logical, default TRUE, controls verbosity}
}
\value{
nothing
}
\description{
load a bed track provided as a data.frame
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{track_loaders}
