% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWASTrack.R
\name{getUrl,GWASTrack-method}
\alias{getUrl,GWASTrack-method}
\alias{getUrl}
\title{the url of the gwas table}
\usage{
\S4method{getUrl}{GWASTrack}(obj)
}
\arguments{
\item{obj}{An object of class GWASTrack}
}
\value{
character
}
\description{
the url of the gwas table
}
\examples{
file <-
  # a local gwas file
  system.file(package = "igvShiny", "extdata", "gwas-5k.tsv.gz")
tbl.gwas <- read.table(file,
                       sep = "\t",
                       header = TRUE,
                       quote = "")
track <-
  GWASTrack(
    "gwas 5k",
    tbl.gwas,
    chrom.col = 12,
    pos.col = 13,
    pval.col = 28
  )
getUrl(track)

}
\keyword{GWASTrack_class}
