% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvR.R
\name{showGenomicRegion,igvR-method}
\alias{showGenomicRegion,igvR-method}
\alias{showGenomicRegion}
\title{Set the visible region, by explicit chromLoc string, or by named features in any curently loaded
annotation tracks}
\usage{
\S4method{showGenomicRegion}{igvR}(obj, region)
}
\arguments{
\item{obj}{An object of class igvR}

\item{region}{A genomic location (rendered "chr5:9,234,343-9,236,000" or as a list:
list(chrom="chr9", start=9234343, end=9236000)) or a labeled annotation in a searchable track,
often a gene symbol, eg "MEF2C"}
}
\value{
""
}
\description{
Set the visible region, by explicit chromLoc string, or by named features in any curently loaded
annotation tracks
}
\examples{
if(interactive()){
   igv <- igvR()
   setGenome(igv, "hg38")
   showGenomicRegion(igv, "MEF2C")
   x <- getGenomicRegion(igv)
      #--------------------
      # zoom out 2kb
      #--------------------
   showGenomicRegion(igv, with(x, sprintf("\%s:\%d-\%d", chrom, start-1000, end+1000)))
   }

}
