% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Track.R
\docType{class}
\name{Track-class}
\alias{Track-class}
\alias{.Track}
\alias{Track}
\title{Constructor for Track}
\usage{
Track(
  trackType = c("annotation", "quantitative", "alignment", "variant", "gwas"),
  sourceType = c("file", "gcs", "ga4gh"),
  fileFormat = c("bed", "gff", "gff3", "gtf", "wig", "bigWig", "bedGraph", "bam", "vcf",
    "seg"),
  trackName,
  onScreenOrder,
  color,
  height,
  autoTrackHeight,
  minTrackHeight,
  maxTrackHeight,
  visibilityWindow
)
}
\arguments{
\item{trackType}{One of "annotation", "quantitative", "variant".}

\item{sourceType}{Only "file" is currently supported.}

\item{fileFormat}{One of "bed", "bedGraph", "vcf"}

\item{trackName}{A character string, used as track label by igv, we recommend unique names per track.}

\item{onScreenOrder}{Numeric, for explicit placement of track within the current set.}

\item{color}{A CSS color name (e.g., "red" or "#FF0000")}

\item{height}{track height, typically in range 20 (for annotations) and up to 1000 (for large sample vcf files)}

\item{autoTrackHeight}{If true, then track height is adjusted dynamically, within the bounds set by minHeight and maxHeight, to accomdodate features in view}

\item{minTrackHeight}{In pixels, minimum allowed}

\item{maxTrackHeight}{In pixels, maximum allowed}

\item{visibilityWindow}{Maximum window size in base pairs for which indexed annotations or variants are displayed. Defaults: 1 MB for variants, whole chromosome for other track types.}
}
\value{
An object of class Track
}
\description{
Constructor for Track
}
\references{
\url{https://github.com/igvteam/igv.js/wiki/Tracks}

\url{https://www.w3schools.com/cssref/css_colors.asp}
}
