% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{remove_nonstandard_chromosomes2d}
\alias{remove_nonstandard_chromosomes2d}
\title{Removes Interactions on Non-standard Chromosomes}
\usage{
remove_nonstandard_chromosomes2d(x)
}
\arguments{
\item{x}{data frame of genomic interactions, with the following columns
(position of columns matter, column names are irrelevant):
\tabular{rll}{
  column 1: \tab \code{chr_a} \tab character; genomic location of anchor A -
  chromosome (e.g., \code{"chr3"})\cr
  column 2: \tab \code{start_a} \tab integer; genomic location of anchor A -
  start coordinate\cr
  column 3: \tab \code{end_a} \tab integer; genomic location of anchor A -
  end coordinate\cr
  column 4: \tab \code{chr_b} \tab character; genomic location of anchor B -
  chromosome (e.g., \code{"chr3"})\cr
  column 5: \tab \code{start_b} \tab integer; genomic location of anchor B -
  start coordinate\cr
  column 6: \tab \code{end_b} \tab integer; genomic location of anchor B -
  end coordinate\cr
  column 7: \tab \code{value} \tab numeric; p-value, FDR, or heuristic used
  to rank the interactions
}}
}
\value{
\code{x} without non-standard chromosomes.
}
\description{
Removes Interactions on Non-standard Chromosomes
}
\examples{
rep1_df <- remove_nonstandard_chromosomes2d(idr2d:::chiapet$rep1_df)

}
