% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{calculate_relative_overlap2d}
\alias{calculate_relative_overlap2d}
\title{Relative Anchor Overlap of two Interactions}
\usage{
calculate_relative_overlap2d(
  int1_anchor_a_start,
  int1_anchor_a_end,
  int1_anchor_b_start,
  int1_anchor_b_end,
  int2_anchor_a_start,
  int2_anchor_a_end,
  int2_anchor_b_start,
  int2_anchor_b_end
)
}
\arguments{
\item{int1_anchor_a_start}{integer vector; genomic start coordinate(s)
of anchor A in replicate 1 interaction}

\item{int1_anchor_a_end}{integer vector; genomic end coordinate(s)
of anchor A in replicate 1 interaction}

\item{int1_anchor_b_start}{integer vector; genomic start coordinate(s)
of anchor B in replicate 1 interaction}

\item{int1_anchor_b_end}{integer vector; genomic end coordinate(s)
of anchor B in replicate 1 interaction}

\item{int2_anchor_a_start}{integer vector; genomic start coordinate(s)
of anchor A in replicate 2 interaction}

\item{int2_anchor_a_end}{integer vector; genomic end coordinate(s)
of anchor A in replicate 2 interaction}

\item{int2_anchor_b_start}{integer vector; genomic start coordinate(s)
of anchor B in replicate 2 interaction}

\item{int2_anchor_b_end}{integer vector; genomic end coordinate(s)
of anchor B in replicate 2 interaction}
}
\value{
numeric vector; relative overlaps between interaction pairs
}
\description{
Calculates the overlap between anchor A of interaction 1 and anchor
A of interaction 2, as well as anchor B of interaction 1 and anchor B of
interaction 2. The overlap (in nucleotides) is then normalized by the length
of the anchors.

Note: anchors A and B of the same interaction have to be on the same
chromosome; start coordinate is always less than end coordinate
}
\examples{
# 100\% overlap
calculate_relative_overlap2d(100, 120, 240, 260,
                             100, 120, 240, 260)

# 50\% overlap
calculate_relative_overlap2d(100, 120, 240, 250,
                             100, 110, 240, 260)

# negative overlap
calculate_relative_overlap2d(100, 120, 240, 250,
                             130, 140, 260, 280)

# larger negative overlap
calculate_relative_overlap2d(100, 120, 240, 250,
                             200, 220, 340, 350)

# vectorized example
calculate_relative_overlap2d(c(100, 100, 100, 100),
                             c(120, 120, 120, 120),
                             c(240, 240, 240, 240),
                             c(260, 250, 250, 250),
                             c(100, 100, 130, 200),
                             c(120, 110, 140, 220),
                             c(240, 240, 260, 340),
                             c(260, 260, 280, 350))
}
