% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structuralTendency.R
\name{structuralTendencyPlot}
\alias{structuralTendencyPlot}
\title{Plotting Structural Tendency of Amino Acid Sequence}
\usage{
structuralTendencyPlot(
  sequence,
  graphType = "pie",
  summarize = FALSE,
  proteinName = NA,
  alphabetical = FALSE,
  disorderPromoting = c("P", "E", "S", "Q", "K", "A", "G"),
  disorderNeutral = c("D", "T", "R"),
  orderPromoting = c("M", "N", "V", "H", "L", "F", "Y", "I", "W", "C"),
  ...
)
}
\arguments{
\item{sequence}{amino acid sequence (or pathway to a fasta file)
as a character string. Supports multiple sequences / files, as a
character vector of strings.}

\item{graphType}{character string, required.
graphType must be set to c("pie", "bar", "none").
When \code{graphType = "pie"}, the output is a pie chart.
When \code{graphType = "bar"}, the output is a bar chart.
When \code{graphType = "none"}, the output is the data frame that would
otherwise be used to plot the data.}

\item{summarize}{logical value, FALSE by default.
When \code{summarize = TRUE}, each residue is aggregated into Disorder
Tendency Groups. (See \code{\link{structuralTendency}} for more details).
When \code{summarize = FALSE}, residue identity is preserved, and
the output is colored by Disorder Tendency Groups.}

\item{proteinName, }{optional character string. NA by default.
Used to either add the name of the protein to the plot title.}

\item{alphabetical}{logical value, FALSE by default.
Order of residues on plot axis. Only relevant when
 \code{summarize = FALSE}, otherwise is ignored.
 If FALSE, ordering is grouped by Disorder Tendency (P, E, S, ..., W, C).
 If TRUE, the residues are ordered alphabetically (A, C, D, E, ..., W, Y).}

\item{disorderPromoting, disorderNeutral, orderPromoting}{character vectors
of individual residues to be matched with the input sequence. Defaults:
\itemize{
  \item disorderPromoting = c("P", "E", "S", "Q", "K", "A", "G")
  \item orderPromoting =
     c("M", "N", "V", "H", "L", "F", "Y", "I", "W", "C")
  \item disorderNeutral = c("D", "T", "R")
}
It is not recommended to change these.}

\item{...}{additional arguments to be passed to
\code{\link{structuralTendency}} and
\code{\link[ggplot2]{ggplot}}}
}
\value{
a data frame containing each residue from the sequence
  matched with its structural tendency, defined by disorderPromoting,
  disorderNeutral, and orderPromoting.
}
\description{
Convenient graphing for the \code{\link{structuralTendency}} function.
}
\section{Plot Colors}{

  For users who wish to keep a common aesthetic, the following colors are
  used when graphType = "bar" or "pie" \cr
  \itemize{
  \item Disorder Neutral = "#F0B5B3"
  \item Disorder Promoting = "darkolivegreen3" or "#A2CD5A"
  \item Order Promoting = "darkorchid1" or "#BF3EFF"
  }
}

\examples{
#Amino acid sequences can be character strings
aaString <- "ACDEFGHIKLMNPQRSTVWY"
#Amino acid sequences can also be character vectors
aaVector <- c("A", "C", "D", "E", "F",
              "G", "H", "I", "K", "L",
              "M", "N", "P", "Q", "R",
              "S", "T", "V", "W", "Y")
#Alternatively, .fasta files can also be used by providing
##The path to the file as a character string
structuralTendencyPlot(aaString)
structuralTendencyPlot(aaVector)

#The plot can be a pie chart (default)
structuralTendencyPlot(aaString,
                    graphType = "pie")

#Or the plot can be a bar graph
structuralTendencyPlot(aaString,
                    graphType = "bar")

#To display general tendency rather than residues, set summarize = T
structuralTendencyPlot(aaString,
                    graphType = "pie",
                    summarize = TRUE)

structuralTendencyPlot(aaString,
                    graphType = "bar",
                    summarize = TRUE)

#If you wish to export this as a dataframe, set graphType = "none"
exampleDF <- structuralTendencyPlot(aaString,
                                  graphType = "none")
head(exampleDF)

#If using a different definition of disordered residues
##These residues are labeled as such from Dunker et al (2001),
##"Intrinsically disordered protein."
structuralTendencyPlot(aaString,
              disorderPromoting = c("A", "R", "G", "Q", "S", "P", "E", "K"),
              disorderNeutral = c("H", "M", "T", "D"),
              orderPromoting = c("W", "C", "F", "I", "Y", "V", "L", "N"),
              graphType = "bar",
              alphabetical = TRUE)
}
\references{
Uversky, V. N. (2013). A decade and a half of protein intrinsic disorder:
  Biology still waits for physics. Protein Science, 22(6), 693-724.
  \url{https://doi.org/10.1002/pro.2261}. \cr
  Kulkarni, Prakash, and Vladimir N. Uversky. "Intrinsically
  disordered proteins: the dark horse of the dark proteome."
  Proteomics 18.21-22 (2018): 1800061.
  \url{https://doi.org/10.1002/pmic.201800061}.
}
\seealso{
Other structural tendency: 
\code{\link{structuralTendency}()}
}
\concept{structural tendency}
