% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{sepguesser}
\alias{sepguesser}
\title{Make an educated guess on the separator character}
\usage{
sepguesser(file, sep_list = c(",", "\\t", ";", " "))
}
\arguments{
\item{file}{The name of the file which the data are to be read from}

\item{sep_list}{A vector containing the candidates for being identified as
separators. Defaults to \code{c(",", "\\t", ";"," ")}}
}
\value{
A character value, corresponding to the guessed separator. One of ","
(comma), "\\t" (tab), ";" (semicolon)," " (whitespace)
}
\description{
This function tries to guess which separator was used in a text delimited file
}
\examples{
sepguesser(system.file("extdata/design_commas.txt", package = "ideal"))
sepguesser(system.file("extdata/design_semicolons.txt", package = "ideal"))
sepguesser(system.file("extdata/design_spaces.txt", package = "ideal"))
mysep <- sepguesser(system.file("extdata/design_tabs.txt", package = "ideal"))

# to be used for reading in the same file, without having to specify the sep
}
