% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/detectTSS.R
\name{detectTSS}
\alias{detectTSS}
\alias{detectTSS,CapSet-method}
\title{Detection of Trancription start sites based on local enrichment}
\usage{
detectTSS(
  CSobject,
  groups,
  outfile_prefix = NULL,
  windowSize = 10L,
  sliding = TRUE,
  foldChange = 2,
  mergeLength = 1L,
  restrictChr = NULL,
  ncores = 1,
  readPos = "start"
)

\S4method{detectTSS}{CapSet}(
  CSobject,
  groups,
  outfile_prefix = NULL,
  windowSize = 10L,
  sliding = TRUE,
  foldChange = 2,
  mergeLength = 1L,
  restrictChr = NULL,
  ncores = 1,
  readPos = "start"
)
}
\arguments{
\item{CSobject}{CapSet object created using \code{\link{newCapSet}} function}

\item{groups}{a character vector that contains group name of the sample, for replicate-based TSS
calling (see example)}

\item{outfile_prefix}{Output name prefix for the .Rdata file containing window counts, background counts
and filtering statistics calculated during TSS detection.}

\item{windowSize}{Size of the window to bin the genome for TSS detection. By default, a window size of
10 is used for binning the genome, however smaller window sizes can optionally be provided
for higher resolution TSS detection. Note that the background size is set to 200x the
window size (2kb for 10bp windows) to calculate local enrichment. Subsequently enriched windows
are merged, unless the mergeLength is increased.}

\item{sliding}{TRUE/FALSE. Indicating whether or not to use sliding windows. The windows are shifted by length which
is half of the specified window length.}

\item{foldChange}{Numeric. A fold change cutoff of local enrichment to detect the TSS. If the
samples have good signal enrichment over background (inspect in genome browser),
a low cutoff of 2-fold can be used. For samples with low sequencing depth it's
also desirable to have a low cutoff of 2-fold. The final "score" of detected TSS
is the mean fold-change of all merged windows that passed the foldChange cutoff.
TSSs can therefore also be filtered using this score after detectTSS is run.}

\item{mergeLength}{Integer. Merge the windows within this distance that pass the foldChange cutoff.
Default (1L) means that only subsequently enriched windows would be merged.}

\item{restrictChr}{Chromosomes to restrict the analysis to.}

\item{ncores}{No. of cores/threads to use}

\item{readPos}{character. position of read to use. Options are "start", "end" and "center". 
For TSS detection, the "start" of reads are used (default). But center or end might be 
useful for detecting RNA-binding proteins (in iCLIP-like data)}
}
\value{
.bed files containing TSS position for each group, along with a bed file for consensus
       (union) TSS sites of all samples.
}
\description{
Detection of Trancription start sites based on local enrichment
}
\examples{

# before running this
# 1. Create a CapSet object
# 2. de-multiplex the fastqs
# 3. map them
# 4. filter duplicate reads from mapped BAM

# load a previously saved CapSet object
cs <- exampleCSobject()
# detect TSS (samples in same group are treated as replicates)
cs <- detectTSS(cs, groups = rep(c("wt","mut"), each = 2), outfile_prefix = "testTSS",
           foldChange = 6, restrictChr = "X", ncores = 1)

}
