% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createGeneSetCommands.R
\name{createGeneSetCommands}
\alias{createGeneSetCommands}
\title{Create gene set commands}
\usage{
createGeneSetCommands(
  collections = c("GO", "KEGG"),
  organism = "org.Hs.eg.db",
  identifier = "ENTREZID"
)
}
\arguments{
\item{collections}{Character vectors specifying the gene set collections of interest.}

\item{organism}{String containing the \pkg{org.*.eg.db} package to use to extract mappings of gene sets to gene IDs.}

\item{identifier}{String specifying the identifier to use to extract IDs for the organism package.}
}
\value{
A list of two character vectors describing how to create collections and retrieve gene sets.
This follows the expectations for \code{commands} in \code{\link{registerFeatureSetCommands}}.
}
\description{
Create the commands required to populate \linkS4class{FeatureSetTable}s with commonly used gene sets.
}
\details{
GO terms are extracted using the \code{"GOALL"} mode,
which extracts both direct and indirect children of each term.
A description for each GO term is extracted using the \pkg{GO.db} package.

Mappings of genes to KEGG pathway are extracted from the organism package using the \code{"PATH"} term.
Unfortunately, this is not up to date due to the licensing around KEGG terms.
Descriptions for each pathway are extracted from \url{http://rest.kegg.jp/list/pathway}.

The output of this function can be used as the \code{commands} argument of \code{\link{registerFeatureSetCommands}}.
It is also used by default in the \code{\link{FeatureSetTable}} constructor when no collections are registered.
}
\examples{
out <- createGeneSetCommands()
cat(out$collections['GO'], "\n")
cat(out$sets['GO'], "\n")

}
\seealso{
\linkS4class{FeatureSetTable}, where the commands are intended for use.

\code{\link{registerFeatureSetCommands}}, to use the commands globally.
}
\author{
Aaron Lun
}
