% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarkdownBoard.R
\docType{methods}
\name{MarkdownBoard-class}
\alias{MarkdownBoard-class}
\alias{MarkdownBoard}
\alias{initialize,MarkdownBoard-method}
\alias{.defineDataInterface,MarkdownBoard-method}
\alias{.createObservers,MarkdownBoard-method}
\alias{.hideInterface,MarkdownBoard-method}
\alias{.fullName,MarkdownBoard-method}
\alias{.panelColor,MarkdownBoard-method}
\alias{.generateOutput,MarkdownBoard-method}
\alias{.renderOutput,MarkdownBoard-method}
\alias{.defineOutput,MarkdownBoard-method}
\alias{.exportOutput,MarkdownBoard-method}
\alias{.definePanelTour,MarkdownBoard-method}
\title{The MarkdownBoard class}
\description{
The MarkdownBoard class renders user-supplied Markdown into HTML to display inside the app.
This is useful for displaying information alongside other panels, or for users to jot down their own notes.
}
\section{Slot overview}{

The following slots are relevant to the rendered content:
\itemize{
\item \code{Content}, a string containing Markdown-formatted text.
This will be rendered to HTML for display inside the app.
}

In addition, this class inherits all slots from its parent \linkS4class{Panel} class.
}

\section{Constructor}{

\code{MarkdownBoard(...)} creates an instance of a MarkdownBoard class,
where any slot and its value can be passed to \code{...} as a named argument.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{RowDataPlot} class.
Refer to the documentation for each method for more details on the remaining arguments.

For defining the interface:
\itemize{
\item \code{\link{.defineDataInterface}(x, se, select_info)} returns a list of interface elements for editing the \code{Content}.
\item \code{\link{.panelColor}(x)} will return the specified default color for this panel class.
\item \code{\link{.hideInterface}(x, field)} will return \code{TRUE} for all selection-related parameters.
\item \code{\link{.fullName}(x)} will return \code{"Volcano plot"}.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for all new slots described above,
as well as in the parent classes via the \linkS4class{RowDataPlot} method.
}

For rendering the display:
\itemize{
\item \code{\link{.defineOutput}(x)} will return a UI element to display the HTML.
\item \code{\link{.renderOutput}(x, se, ..., output, pObjects, rObjects)} will add reactive expressions to render the HTML.
\item \code{\link{.generateOutput}(x, se, all_memory, all_contents)} will render the Markdown to HTML via the \pkg{rmarkdown} package,
returning a string containing the rendered content in the \code{text} element of the output list.
The Markdown-formatted content is converted into an R comment for code tracking purposes.
\item \code{\link{.exportOutput}(x, se, all_memory, all_contents)} will create a HTML containing the rendered Markdown, and return a string containing the path to that HTML.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing the steps of a panel-specific tour.
Not that there's a great deal to say here.
}
}

\examples{
if (interactive()) {
    iSEE(SummarizedExperiment(), initial=list(MarkdownBoard()))
}

}
\seealso{
\linkS4class{Panel}, for the base class.
}
\author{
Aaron Lun
}
