% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/class-RowTreePlot.R
\docType{class}
\name{RowTreePlot-class}
\alias{RowTreePlot-class}
\alias{RowTreePlot}
\title{Row tree plot}
\value{
The \code{RowTreePlot(...)} constructor creates an instance of a RowTreePlot
class, where any slot and its value can be passed to \code{...} as a named
argument.
}
\description{
Hierarchical tree for the rows of a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-constructor]{TreeSummarizedExperiment}}
object. The tree can be produced with \code{\link[mia:taxonomy-methods]{addTaxonomyTree}}
and gets stored in the \code{\link[TreeSummarizedExperiment:rowLinks]{rowTree}}
slot of the experiment object. The panel implements \code{\link[miaViz:plotTree]{plotRowTree}}
to generate the plot.
}
\section{Slot overview}{


This class inherits all slots from its parent class \linkS4class{TreePlot}.
}

\examples{
# Import TreeSE
library(mia)
data("Tengeler2020", package = "mia")
tse <- Tengeler2020

# Store panel into object
panel <- RowTreePlot()
# View some adjustable parameters
head(slotNames(panel))

# Launch iSEE with custom initial panel
if (interactive()) {
  iSEE(tse, initial = c(panel))
}

}
\seealso{
\linkS4class{TreePlot}
\linkS4class{ColumnTreePlot}
}
\author{
Giulio Benedetti
}
