% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/class-PrevalencePlot.R
\docType{class}
\name{PrevalencePlot-class}
\alias{PrevalencePlot-class}
\alias{PrevalencePlot}
\title{Prevalence plot}
\value{
The \code{PrevalencePlot(...)} constructor creates an instance of an
PrevalencePlot class, where any slot and its value can be passed to
\code{...} as a named argument.
}
\description{
Prevalence plot of all or agglomerated features in a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object. The panel implements \code{\link[miaViz:plotAbundance]{plotPrevalence}}
to generate the plot.
}
\section{Slot overview}{

The following slots control the thresholds used in the visualization:
\itemize{
\item \code{detection} \code{Numeric scalar}. Detection threshold between 0
and 1 for absence/presence. (Defualt: \code{0})

\item \code{prevalence} \code{Numeric scalar}. Prevalence threshold between 0
and 1. The required prevalence is strictly greater by default. To
include the limit, set \code{include.lowest} to \code{TRUE}. (Default:
\code{0})

\item \code{assay.type} \code{Character scalar}. The name of the assay to
show. (Default: \code{"relabundance"})

\item \code{rank} \code{Character scalar}. The taxonomic rank to visualise.
(Default: \code{NULL})

\item \code{show.rank} \code{Logical scalar}. Should options for the
taxonomic rank appear. (Default: \code{FALSE})

\item \code{include.lowest} \code{Logical scalar}. Should features with
prevalence equal to \code{prevalence} be included. (Default: \code{FALSE})
}

In addition, this class inherits all slots from its parent class
\code{\link[iSEE:Panel-class]{Panel}}.
}

\examples{
# Import TreeSE
library(mia)
data("Tengeler2020", package = "mia")
tse <- Tengeler2020

tse <- transformAssay(tse,
                      assay.type = "counts",
                      method = "relabundance")

# Store panel into object
panel <- PrevalencePlot()
# View some adjustable parameters
head(slotNames(panel))

# Launch iSEE with custom initial panel
if (interactive()) {
  iSEE(tse, initial = c(panel))
}

}
\author{
Giulio Benedetti
}
