% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/family-GraphPlot.R
\docType{class}
\name{GraphPlot-class}
\alias{GraphPlot-class}
\alias{GraphPlot}
\title{Graph plot}
\description{
The Graph plot is a virtual class that showcases the network organisation of
either the features or samples of a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object. The \linkS4class{RowGraphPlot} and \linkS4class{ColumnGraphPlot}
classes belong to this family and are specialised to visualise the feature
or sample igraphs stored in metadata, respectively.
}
\section{Slot overview}{

The following slots control the thresholds used in the visualisation:
\itemize{
\item \code{name}: \code{Character scalar}. Metadata name containing graph.
(Default: \code{"graph"})
\item \code{assay.type}: \code{Character scalar}. Assay type to use.
(Default: \code{"counts"})
\item \code{layout}: \code{Character scalar}. Graph layout.
(Default: \code{"kk"})
\item \code{edge.type}: \code{Character scalar}. Edge type.
(Default: \code{"fan"})
\item \code{show.label}: \code{Logical scalar}. Should node labels be shown.
(Default: \code{FALSE})
\item \code{add.legend}: \code{Logical scalar}. Should legend be shown.
(Default: \code{TRUE})
\item \code{edge.colour.by}: \code{Character scalar}. Parameter to colour
lines by when \code{colour_parameters = "Edge"}. (Default: \code{NULL})
\item \code{edge.size.by}: \code{Character scalar}. Parameter to size lines
by when \code{size_parameters = "Edge"}. (Default: \code{NULL})
\item \code{node.colour.by}: \code{Character scalar}. Parameter to colour
nodes by when \code{colour_parameters = "Node"}. (Default: \code{NULL})
\item \code{node.size.by}: \code{Character scalar}. Parameter to size nodes
by when \code{size_parameters = "Node"}. (Default: \code{NULL})
\item \code{node.shape.by}: \code{Character scalar}. Parameter to shape nodes
by when \code{shape_parameters = "Node"}. (Default: \code{NULL})
}

In addition, this class inherits all slots from its parent class
\code{\link[iSEE:Panel-class]{Panel}}.
}

\seealso{
\linkS4class{RowGraphPlot}
\linkS4class{ColumnGraphPlot}
}
\author{
Giulio Benedetti
}
