% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/class-AbundanceDensityPlot.R
\docType{class}
\name{AbundanceDensityPlot-class}
\alias{AbundanceDensityPlot-class}
\alias{AbundanceDensityPlot}
\title{Abundance density plot}
\value{
The \code{AbundanceDensityPlot(...)} constructor creates an instance of an
AbundanceDensityPlot class, where any slot and its value can be passed to
\code{...} as a named argument.
}
\description{
Density abundance profile of single features in a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-constructor]{TreeSummarizedExperiment}}.
The panel implements \code{\link[miaViz:plotAbundanceDensity]{plotAbundanceDensity}}
to generate the plot.
}
\section{Slot overview}{

The following slots control the thresholds used in the visualisation:
\itemize{
\item \code{layout}, a string specifying abundance layout (jitter, density or points).
\item \code{assay.type}, a string specifying the assay to visualize.
\item \code{n}, a number indicating the number of top taxa to visualize.
\item \code{flipped}, a logical specifying if the axis should be switched.
\item \code{order_descending}, a string specifying the descending order.
}

In addition, this class inherits all slots from its parent class
\code{\link[iSEE:Panel-class]{Panel}}.
}

\examples{
# Import TreeSE
library(mia)
data("Tengeler2020", package = "mia")
tse <- Tengeler2020

# Add relabundance assay
tse <- transformAssay(tse, method = "relabundance")

# Store panel into object
panel <- AbundanceDensityPlot()
# View some adjustable parameters
head(slotNames(panel))

# Launch iSEE with custom initial panel
if (interactive()) {
  iSEE(tse, initial = c(panel))
}

}
\author{
Giulio Benedetti
}
