% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEEindexResource-class.R
\name{iSEEindexLocalhostResource-class}
\alias{iSEEindexLocalhostResource-class}
\alias{precache,iSEEindexLocalhostResource-method}
\alias{iSEEindexLocalhostResource}
\title{The iSEEindexLocalhostResource class}
\usage{
iSEEindexLocalhostResource(x)
}
\arguments{
\item{x}{List of metadata. See Details.}
}
\value{
The constructor function \code{iSEEindexLocalhostResource()} returns an
object of object of class \code{iSEEindexLocalhostResource}.
}
\description{
The iSEEindexLocalhostResource class represents a resource accessible through
a local filepath.
A URI for this type of resource uses the prefix \dQuote{localhost://}.
}
\details{
Required metadata:

\describe{
\item{uri}{Character scalar. URI of the resource.}
}
}
\section{Slot overview}{

This class inherits all slots from its parent class \linkS4class{iSEEindexResource}.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a
\linkS4class{iSEEindexLocalhostResource} class.
Refer to the documentation for each method for more details on the remaining
arguments.

\itemize{
\item \code{\link{precache}(x, ...)} trims the \verb{localhost://} prefix, and
caches a copy of the resource located at the resulting file path using
\pkg{BiocFileCache}, before returning the file path to the cached file.
}
}

\section{Absolute and relative paths}{


Absolute and relative paths are both supported.

Absolute paths require an additional \code{/} (forward slash)
following the double forward slash \verb{//} separating the scheme component of
the URI.

For instance:

\itemize{
\item \verb{localhost://path/to/file} refers to the relative path \code{path/to/file}
(relative to the working directory when the Shiny application is launched).
\item \verb{localhost:///path/to/file} refers to the absolute path \verb{/path/to/file}.
}
}

\examples{
iSEEindexLocalhostResource(list(uri = "localhost:///example/absolute/path"))
iSEEindexLocalhostResource(list(uri = "localhost://example/relative/path"))
}
\author{
Kevin Rue-Albrecht
}
