% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEEinit.R
\name{iSEEinit}
\alias{iSEEinit}
\title{iSEEinit: Create an initial state of an iSEE instance for gene expression
visualization}
\usage{
iSEEinit(
  sce,
  features,
  reddim_type = "TSNE",
  clusters = colnames(colData(sce))[1],
  groups = colnames(colData(sce))[1],
  gene_id = "id",
  add_markdown_panel = FALSE
)
}
\arguments{
\item{sce}{SingleCellExperiment object}

\item{features}{A character vector or a data.frame containing a list of genes.
If \code{features} is a data.frame, the column containing the gene names must be named "id"}

\item{reddim_type}{A string vector containing the dimensionality reduction
type}

\item{clusters}{A character string containing the name of the
clusters/cell-type/state...(as listed in the colData of the sce)}

\item{groups}{A character string of the groups/conditions...(as it appears in
the colData of the sce)}

\item{gene_id}{A character string containing the name of the column name containing
gene names/ids, when 'features' is a data.frame}

\item{add_markdown_panel}{A logical indicating whether or not to include the
MarkdownBoard panel in the initial configuration}
}
\value{
A list of "Panel" objects specifying the initial state of iSEE
instance
}
\description{
\code{iSEEinit()} defines the initial setup of an iSEE instance, recommending
tailored visual elements to effortlessly illustrate the expression of a gene
list in a single view.
}
\examples{
sce <- scRNAseq::RichardTCellData()
sce <- scuttle::logNormCounts(sce)
sce <- scater::runPCA(sce)
sce <- scater::runTSNE(sce)
gene_list <- c("ENSMUSG00000026581",
               "ENSMUSG00000005087",
               "ENSMUSG00000015437")
cluster <- "stimulus"
group <- "single cell quality"
initial <- iSEEinit(sce = sce, features = gene_list, clusters = cluster, groups = group)
}
