% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEEDESeq2-class.R
\docType{methods}
\name{iSEEDESeq2Results-class}
\alias{iSEEDESeq2Results-class}
\alias{iSEEDESeq2Results}
\alias{showAsCell,iSEEDESeq2Results-method}
\alias{pValue,iSEEDESeq2Results-method}
\alias{log2FoldChange,iSEEDESeq2Results-method}
\alias{averageLog2,iSEEDESeq2Results-method}
\alias{embedContrastResults,iSEEDESeq2Results-method}
\alias{embedContrastResults,DESeqResults-method}
\title{The iSEEDESeq2Results class}
\description{
The \code{iSEEDESeq2Results} class is used to provide a common interface to differential expression results produced by the \pkg{DESeq2} package.
It provides methods to access common differential expression statistics (e.g., log2 fold-change, p-value, log2 average abundance).
}
\details{
This class inherits all its slots directly from its parent class \linkS4class{DataFrame}.
}
\section{Constructor}{

\code{iSEEDESeq2Results(data, row.names = rownames(data))} creates an instance of a \code{iSEEDESeq2Results} class, with:

\describe{
\item{\code{data}}{A \code{data.frame} produced by \code{DESeq2::results()} or \code{DESeq2::lfcShrink()}.}
\item{\code{row.names}}{The character vector of rownames for the \linkS4class{SummarizedExperiment} object in which the object is to be embedded. Must be a superset of \code{rownames(data)}.}
}
}

\section{Supported methods}{

\itemize{
\item \code{embedContrastResults(x, se, name, ...)} embeds \code{x} in \code{se} under the identifier \code{name}. See \code{\link[=embedContrastResults]{embedContrastResults()}} for more details.
\item \code{pValue(x)} returns the vector of raw p-values.
\item \code{log2FoldChange(x)} returns the vector of log2-fold-change values.
\item \code{averageLog2(x)} returns the vector of average log2-expression values.
}
}

\examples{
library(DESeq2)

##
# From DESeq2::DESeq() ----
##

cnts <- matrix(rnbinom(n = 1000, mu = 100, size = 1 / 0.5), ncol = 10)
rownames(cnts) <- paste("Gene", 1:100)
cond <- factor(rep(1:2, each = 5))

# object construction
dds <- DESeqDataSetFromMatrix(cnts, DataFrame(cond), ~cond)

# standard analysis
dds <- DESeq(dds)
res <- results(dds)
head(res)

##
# iSEEDESeq2Results ----
##

# Embed the DESeq2 results in the SummarizedExperiment object
dds <- embedContrastResults(res, dds, name = "DESeq2")

##
# Access ----
##

contrastResultsNames(dds)
contrastResults(dds)
contrastResults(dds, "DESeq2")

head(pValue(contrastResults(dds, "DESeq2")))
head(log2FoldChange(contrastResults(dds, "DESeq2")))
head(averageLog2(contrastResults(dds, "DESeq2")))
}
\author{
Kevin Rue-Albrecht
}
