% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_class.R
\name{validate-utils}
\alias{validate-utils}
\alias{.singleStringError}
\alias{.validLogicalError}
\alias{.validStringError}
\alias{.allowableChoiceError}
\alias{.multipleChoiceError}
\alias{.validNumberError}
\title{Validation error utilities}
\usage{
.singleStringError(msg, x, fields)

.validLogicalError(msg, x, fields)

.validStringError(msg, x, fields)

.allowableChoiceError(msg, x, field, allowable)

.multipleChoiceError(msg, x, field, allowable)

.validNumberError(msg, x, field, lower, upper)
}
\arguments{
\item{msg}{Character vector containing the current error messages.}

\item{x}{An instance of a \linkS4class{Panel} subclass.}

\item{fields}{Character vector containing the names of the relevant slots.}

\item{field}{String containing the name of the relevant slot under investigation.}

\item{allowable}{Character vector of allowable choices for a multiple-choice selection.}

\item{lower}{Numeric scalar specifying the lower bound of possible values.}

\item{upper}{Numeric scalar specifying the upper bound of possible values.}
}
\value{
All functions return a character vector containing \code{msg}, possibly appended with additional error messages.
}
\description{
Helper functions to implement \code{\link{setValidity}} methods for \linkS4class{Panel} subclasses.
}
\details{
\code{.singleStringError} adds an error message if any of the slots named in \code{fields} does not contain a single string.

\code{.validStringError} adds an error message if any of the slots named in \code{fields} does not contain a single non-\code{NA} string.

\code{.validLogicalError} adds an error message if any of the slots named in \code{fields} does not contain a non-\code{NA} logical scalar.

\code{.allowableChoiceError} adds an error message if the slot named \code{field} does not have a value in \code{allowable}, assuming it contains a single string.

\code{.multipleChoiceError} adds an error message if the slot named \code{field} does not have all of its values in \code{allowable}, assuming it contains a character vector of any length.

\code{.validNumberError} adds an error message if the slot named \code{field} is not a non-\code{NA} number within [\code{lower}, \code{upper}].
}
\author{
Aaron Lun
}
