% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_reactive.R
\name{.retrieveOutput}
\alias{.retrieveOutput}
\title{Retrieve the panel output}
\usage{
.retrieveOutput(panel_name, se, pObjects, rObjects)
}
\arguments{
\item{panel_name}{String containing the panel name.}

\item{se}{A \linkS4class{SummarizedExperiment} object containing the current dataset.}

\item{pObjects}{An environment containing global parameters generated in the \code{\link{iSEE}} app.}

\item{rObjects}{A reactive list of values generated in the \code{\link{iSEE}} app.}
}
\value{
The output of running \code{\link{.generateOutput}} for the current panel.
Several fields in \code{pObjects} are also modified as a side-effect.
}
\description{
Retrieve the results of a previous \code{\link{.generateOutput}} call on this panel.
}
\details{
This function should be used in the rendering expression in \code{\link{.renderOutput}}.
It takes care of a number of house-keeping tasks required to satisfy \code{\link{.renderOutput}}'s requirements, e.g., responding to \code{\link{.requestUpdate}} modifications to \code{rObjects}, setting the \code{commands} and \code{contents} and \code{varname} in \code{pObjects}.

This function will attempt to retrieve the cached output of \code{\link{.generateOutput}} if it was used elsewhere in the app.
After retrieval, the cached value is wiped to ensure that it does not go stale.
If no cached value is found, \code{\link{.generateOutput}} is called directly.
}
\seealso{
\code{\link{.renderOutput}}, where this function should be called.

\code{\link{.generateOutput}}, which is called by this function.
}
\author{
Aaron Lun
}
