% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{documentation-generics}
\alias{documentation-generics}
\alias{.definePanelTour}
\alias{.getDotPlotColorHelp}
\title{Documentation generics}
\description{
The generics power the creation of panel-specific documentation within the \code{\link{iSEE}} app.
Users can click on an icon next to the panel name to open a self-guided tour for that panel's functionality.
}
\section{Defining the panel tour}{

\code{.definePanelTour(x)} takes a \linkS4class{Panel} \code{x} and is expected to return a data.frame
with the character fields \code{"element"} and \code{"intro"}.
Each row corresponds to a step of an \pkg{rintrojs} tour;
the \code{"element"} specifies the active UI element to be highlighted in that step,
while the \code{"intro"} element contains the HTML-formatted text to show in the tour pop-up.

It is a good idea to \code{\link{callNextMethod}()} to obtain the tour steps for the parent class to append onto the current class's data.frame.
In some cases, modification of the parent class's tour steps may be necessary if some of the parent's functionality has been overwritten.
Some communication with the parent's maintainers may be necessary to establish a stable way to identify the rows corresponding to the steps to be written, 
e.g., based on the row names of the data.frame.

A tour for a Panel \code{x} is expected to only highlight UI elements \emph{on the same panel}.
This is very important as other panels cannot be assumed to exist in an arbitrary instance of \code{\link{iSEE}}.
As such, these tours are not well-suited to highlighting interactions between different panels.

The observer set-up for the panel tour is done in \code{\link{.createObservers}} for the base \linkS4class{Panel} class.
No further action is required on behalf of developers to set up the triggers to launch the tour.
}

\section{Defining UI-specific tours}{

It is possible to provide tours for individual UI elements, which can be more helpful than a single large tour for the entire panel.
A documented element has a clickable icon (usually generated by functions like \code{\link{.selectInput.iSEE}}) that launches a specific tour,
typically explaining the behavior and effects of the associated parameter.
The tours themselves should be registered by \code{\link{.addSpecificTour}}.
This is best done inside the various interface-defining functions (e.g., \code{\link{.defineInterface}} and related methods)
where the documentation can be written adjacent to the definition of the UI element itself.

For a \linkS4class{DotPlot} instance \code{x}, the \code{.getDotPlotColorHelp(x, color_choices)} generic should return a function that returns a data.frame
containing the \pkg{rintrojs} tour for the color choice UI element, i.e., \code{"ColorBy"}.
This allows downstream Panels to tune the wording of the color documentation, given that this is commonly specialized. 
\code{color_choices} is a character vector that contains the valid choices for the \code{"ColorBy"} radio button;
some input datasets will not have, e.g., any column data, so the corresponding button will not be shown and its associated tour can be omitted.
}

\author{
Aaron Lun
}
