% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCustomPanels.R
\name{createCustomPanels}
\alias{createCustomPanels}
\alias{createCustomTable}
\alias{createCustomPlot}
\title{Create custom panels}
\usage{
createCustomTable(
  FUN,
  restrict = NULL,
  className = "CustomTable",
  fullName = "Custom table",
  FUN.selection.details = NULL,
  where = topenv(parent.frame())
)

createCustomPlot(
  FUN,
  restrict = NULL,
  className = "CustomPlot",
  fullName = "Custom plot",
  where = topenv(parent.frame())
)
}
\arguments{
\item{FUN}{A function that generates a data.frame or a \link{ggplot},
for \code{createCustomTable} and \code{createCustomPlot} respectively.
See Details for the expected arguments.}

\item{restrict}{Character vector of names of optional arguments in \code{FUN} to which the UI is restricted.
If specified, only the listed arguments receive UI elements in the interface.}

\item{className}{String containing the name of the new \linkS4class{Panel} class.}

\item{fullName}{String containing the full name of the new class.}

\item{FUN.selection.details}{Function generating a UI element that displays details about the current selection, if any.}

\item{where}{An environment indicating where the class and method definitions should be stored.}
}
\value{
A new class and its methods are defined in the global environment.
A generator function for creating new instances of the class is returned.
}
\description{
Helper functions for quick-and-dirty creation of custom panels,
usually in the context of a one-off application.
This creates a new class with specialized methods for showing content based on a user-specified function.
}
\details{
\code{FUN} is expected to have the following first 3 arguments:
\itemize{
\item \code{se}, a \linkS4class{SummarizedExperiment} object for the current dataset of interest.
\item \code{rows}, a list of row selections received from the transmitting panel.
This contains one or more character vectors of row names in active and saved selections.
Alternatively, this may be \code{NULL} if no selection has been made in the transmitter.
\item \code{columns}, a list of column selections received from the transmitting panel.
This contains one or more character vectors of column names in active and saved selections.
Alternatively, this may be \code{NULL} if no selection has been made in the transmitter.
}

Any number of additional named arguments may also be present in \code{FUN}.
All such arguments should have default values,
as these are used to automatically generate UI elements in the panel:
\itemize{
\item Character vectors will get a \code{\link{selectInput}}.
\item Strings will get a \code{\link{textInput}}.
\item Numeric scalars will get a \code{\link{numericInput}}.
\item Logical scalars will get a \code{\link{checkboxInput}}.
}
Arguments with other types of default values are ignored.
If \code{restrict} is specified, arguments will only have corresponding UI elements if they are listed in \code{restrict}.
All user interactions with these elements will automatically trigger regeneration of the panel contents.

Classes created via these functions are extremely limited.
Only scalar inputs are supported via the UI and all panels cannot transmit to the rest of the app.
We recommend only using these functions for one-off applications to quickly prototype concepts;
serious \linkS4class{Panel} extensions should be done explicitly.
}
\examples{
library(scater)
CUSTOM_DIMRED <- function(se, rows, columns, ntop=500, scale=TRUE,
    mode=c("PCA", "TSNE", "UMAP"))
{
    if (is.null(columns)) {
        return(
            ggplot() + theme_void() + geom_text(
                aes(x, y, label=label),
                data.frame(x=0, y=0, label="No column data selected."),
                size=5)
            )
    }

    mode <- match.arg(mode)
    if (mode=="PCA") {
        calcFUN <- runPCA
    } else if (mode=="TSNE") {
        calcFUN <- runTSNE
    } else if (mode=="UMAP") {
        calcFUN <- runUMAP
    }

    kept <- se[, unique(unlist(columns))]
    kept <- calcFUN(kept, ncomponents=2, ntop=ntop,
        scale=scale, subset_row=unique(unlist(rows)))
    plotReducedDim(kept, mode)
}

GEN <- createCustomPlot(CUSTOM_DIMRED)
GEN()

if (interactive()) {
    library(scRNAseq)
    sce <- ReprocessedAllenData("tophat_counts")
    library(scater)
    sce <- logNormCounts(sce, exprs_values="tophat_counts")

    iSEE(sce, initial=list(
        ColumnDataPlot(PanelId=1L),
        GEN(ColumnSelectionSource="ColumnDataPlot1")
    ))
}

}
\author{
Aaron Lun
}
