% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExperimentColorMap.R
\name{checkColormapCompatibility}
\alias{checkColormapCompatibility}
\title{Check compatibility between ExperimentColorMap and SummarizedExperiment
objects}
\usage{
checkColormapCompatibility(ecm, se)
}
\arguments{
\item{ecm}{An \linkS4class{ExperimentColorMap}.}

\item{se}{A \linkS4class{SingleCellExperiment}.}
}
\value{
A character vector of incompatibility error messages, if any.
}
\description{
This function compares a pair of \linkS4class{ExperimentColorMap} and
\linkS4class{SingleCellExperiment} objects, and examines whether
all of the \code{assays}, \code{colData}, and \code{rowData} defined
in the ExperimentColorMap object exist in the SingleCellExperiment object.
}
\examples{

# Example colormaps ----

count_colors <- function(n){
  c("black","brown","red","orange","yellow")
}

qc_color_fun <- function(n){
  qc_colors <- c("forestgreen", "firebrick1")
  names(qc_colors) <- c("Y", "N")
  return(qc_colors)
}

ecm <- ExperimentColorMap(
    assays = list(
        tophat_counts = count_colors
    ),
    colData = list(
        passes_qc_checks_s = qc_color_fun
    )
)

# Example SingleCellExperiment ----

library(scRNAseq)
sce <- ReprocessedAllenData(assays="tophat_counts")

# Test for compatibility ----

checkColormapCompatibility(ecm, sce)

}
\author{
Kevin Rue-Albrecht
}
