% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_class.R
\name{cache-utils}
\alias{cache-utils}
\alias{.findAtomicFields}
\alias{.whichGroupable}
\alias{.whichNumeric}
\alias{.isAssayNumeric}
\title{Caching utilities}
\usage{
.findAtomicFields(x)

.whichGroupable(x, max_levels = Inf)

.whichNumeric(x)

.isAssayNumeric(se, i)
}
\arguments{
\item{x}{A data.frame or \linkS4class{DataFrame}, most typically the \code{\link{rowData}} or \code{\link{colData}}.}

\item{max_levels}{Integer scalar specifying the maximum number unique values for \code{x} to be categorical.}

\item{se}{The \linkS4class{SummarizedExperiment} object.}

\item{i}{An integer scalar or string specifying the assay of interest in \code{se}.}
}
\value{
For \code{.findAtomicFields}, a character vector of names of columns in \code{x} containing atomic R types.

For \code{.whichNumeric}, an integer vector containing the indices of the numeric columns.

For \code{.whichGroupable}, an integer vector containing the indices of the categorical columns.

For \code{.isAssayNumeric}, a logical scalar indicating whether the specified assay as numeric.
}
\description{
Utility functions to be used in a \code{\link{.cacheCommonInfo}} method, usually to identify names of elements of the \linkS4class{SummarizedExperiment} for later use in \code{\link{.defineInterface}} to populate the user interface.
}
\details{
\code{.findAtomicFields} is necessary as many of the widgets used by \code{\link{iSEE}} (e.g., \code{\link{ggplot}}, \code{\link{datatable}}) do not know how to handle more complex types being stored as columns.
Similarly, \code{.whichNumeric} and \code{.whichGroupable} can be used to specify options for visualization modes that only make sense for continuous or discrete variables respectively (e.g., sizing, faceting).
}
\examples{
x <- DataFrame(
    A = rnorm(10),
    B = sample(letters, 10),
    DataFrame = I(DataFrame(
        C = rnorm(10),
        D = sample(letters, 10)
    ))
)

.findAtomicFields(x)
.whichGroupable(x)
.whichNumeric(x)
}
\author{
Aaron Lun, Kevin Rue-Albrecht, Charlotte Soneson
}
