% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_ReducedDimensionPlot.R
\docType{methods}
\name{ReducedDimensionPlot-class}
\alias{ReducedDimensionPlot-class}
\alias{ReducedDimensionPlot}
\alias{initialize,ReducedDimensionPlot-method}
\alias{.refineParameters,ReducedDimensionPlot-method}
\alias{.cacheCommonInfo,ReducedDimensionPlot-method}
\alias{.defineDataInterface,ReducedDimensionPlot-method}
\alias{.createObservers,ReducedDimensionPlot-method}
\alias{.fullName,ReducedDimensionPlot-method}
\alias{.panelColor,ReducedDimensionPlot-method}
\alias{.generateDotPlotData,ReducedDimensionPlot-method}
\alias{.definePanelTour,ReducedDimensionPlot-method}
\title{The ReducedDimensionPlot panel}
\description{
The ReducedDimensionPlot is a panel class for creating a \linkS4class{ColumnDotPlot} where the coordinates of each column/sample are taken from the \code{\link{reducedDims}} of a \linkS4class{SingleCellExperiment} object.
It provides slots and methods to specify which dimensionality reduction result to use and to create the data.frame with the coordinates of the specified results for plotting.
}
\section{ReducedDimensionPlot slot overview}{

The following slots control the dimensionality reduction result that is used:
\itemize{
\item \code{Type}, a string specifying the name of the dimensionality reduction result.
If \code{NA}, defaults to the first entry of \code{\link{reducedDims}}.
\item \code{XAxis}, integer scalar specifying the dimension to plot on the x-axis.
Defaults to 1.
\item \code{YAxis}, integer scalar specifying the dimension to plot on the y-axis.
Defaults to 2.
}

In addition, this class inherits all slots from its parent \linkS4class{ColumnDotPlot}, \linkS4class{DotPlot} and \linkS4class{Panel} classes.
}

\section{Constructor}{

\code{ReducedDimensionPlot(...)} creates an instance of a ReducedDimensionPlot class, where any slot and its value can be passed to \code{...} as a named argument.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{ReducedDimensionPlot} class.
Refer to the documentation for each method for more details on the remaining arguments.

For setting up data values:
\itemize{
\item \code{\link{.cacheCommonInfo}(x)} adds a \code{"ReducedDimensionPlot"} entry containing \code{valid.reducedDim.names}, a character vector of names of valid dimensionality reduction results (i.e., at least one dimension).
This will also call the equivalent \linkS4class{ColumnDotPlot} method.
\item \code{\link{.refineParameters}(x, se)} replaces \code{NA} values in \code{RedDimType} with the first valid dimensionality reduction result name in \code{se}.
This will also call the equivalent \linkS4class{ColumnDotPlot} method for further refinements to \code{x}.
If no dimensionality reduction results are available, \code{NULL} is returned instead.
}

For defining the interface:
\itemize{
\item \code{\link{.defineDataInterface}(x, se, select_info)} returns a list of interface elements for manipulating all slots described above.
\item \code{\link{.panelColor}(x)} will return the specified default color for this panel class.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for all slots described above and in the parent classes.
This will also call the equivalent \linkS4class{ColumnDotPlot} method.
}

For defining the panel name:
\itemize{
\item \code{\link{.fullName}(x)} will return \code{"Reduced dimension plot"}.
}

For creating the plot:
\itemize{
\item \code{\link{.generateDotPlotData}(x, envir)} will create a data.frame of reduced dimension coordinates in \code{envir}.
It will return the commands required to do so as well as a list of labels.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing a panel-specific tour.
}

Subclasses do not have to provide any methods, as this is a concrete class.
}

\examples{
#################
# For end-users #
#################

x <- ReducedDimensionPlot()
x[["Type"]]
x[["Type"]] <- "TSNE"

##################
# For developers #
##################

library(scater)
sce <- mockSCE()
sce <- logNormCounts(sce)

# Spits out a NULL and a warning if no reducedDims are available.
sce0 <- .cacheCommonInfo(x, sce)
.refineParameters(x, sce0)

# Replaces the default with something sensible.
sce <- runPCA(sce)
sce0 <- .cacheCommonInfo(x, sce)
.refineParameters(x, sce0)

}
\seealso{
\linkS4class{ColumnDotPlot}, for the immediate parent class.
}
\author{
Aaron Lun
}
