% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family_ColumnDotPlot.R
\docType{methods}
\name{ColumnDotPlot-class}
\alias{ColumnDotPlot-class}
\alias{initialize,ColumnDotPlot-method}
\alias{.cacheCommonInfo,ColumnDotPlot-method}
\alias{.refineParameters,ColumnDotPlot-method}
\alias{.defineInterface,ColumnDotPlot-method}
\alias{.createObservers,ColumnDotPlot-method}
\alias{.getTooltipUI,ColumnDotPlot-method}
\alias{.hideInterface,ColumnDotPlot-method}
\alias{.multiSelectionDimension,ColumnDotPlot-method}
\alias{.multiSelectionResponsive,ColumnDotPlot-method}
\alias{.multiSelectionRestricted,ColumnDotPlot-method}
\alias{.multiSelectionInvalidated,ColumnDotPlot-method}
\alias{.singleSelectionDimension,ColumnDotPlot-method}
\alias{.definePanelTour,ColumnDotPlot-method}
\alias{.getDotPlotColorHelp,ColumnDotPlot-method}
\alias{[[,ColumnDotPlot-method}
\alias{[[,ColumnDotPlot,ANY,ANY-method}
\alias{[[<-,ColumnDotPlot-method}
\alias{[[<-,ColumnDotPlot,ANY,ANY-method}
\alias{updateObject,ColumnDotPlot-method}
\title{The ColumnDotPlot virtual class}
\description{
The ColumnDotPlot is a virtual class where each column in the \linkS4class{SummarizedExperiment} is represented by no more than one point (i.e., a \dQuote{dot}) in a brushable \link{ggplot} plot.
It provides slots and methods to extract \code{\link{colData}} fields to control the per-point aesthetics on the plot.
This panel will transmit column identities in both its single and multiple selections, and it can receive multiple column selections but not multiple row selections.
}
\section{Slot overview}{

The following slots control coloring of the points:
\itemize{
\item \code{ColorByColumnData}, a string specifying the \code{\link{colData}} field for controlling point color,
if \code{ColorBy="Column data"} (see the \linkS4class{Panel} class).
Defaults to the first valid field (see \code{.cacheCommonInfo} below).
\item \code{ColorByFeatureNameAssay}, a string specifying the assay of the SummarizedExperiment object containing values to use for coloring,
if \code{ColorBy="Feature name"}.
Defaults to \code{"logcounts"} in \code{\link{getPanelDefault}}, falling back to the name of the first valid assay 
(see \code{?"\link{.cacheCommonInfo,DotPlot-method}"} for the definition of validity).
\item \code{ColorBySampleNameColor}, a string specifying the color to use for coloring an individual sample on the plot,
if \code{ColorBy="Sample name"}.
Defaults to \code{"red"} in \code{\link{getPanelDefault}}.
}

The following slots control other metadata-related aesthetic aspects of the points:
\itemize{
\item \code{ShapeByColumnData}, a string specifying the \code{\link{colData}} field for controlling point shape,
if \code{ShapeBy="Column data"} (see the \linkS4class{Panel} class).
The specified field should contain categorical values; defaults to the first such valid field.
\item \code{SizeByColumnData}, a string specifying the \code{\link{colData}} field for controlling point size,
if \code{SizeBy="Column data"} (see the \linkS4class{Panel} class).
The specified field should contain continuous values; defaults to the first such valid field.
\item \code{TooltipColumnData}, a character vector specifying \code{\link{colData}} fields to show in the tooltip.
Defaults to `character(0)`, which displays only the `colnames` value of the data point.
}

In addition, this class inherits all slots from its parent \linkS4class{DotPlot} and \linkS4class{Panel} classes.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{ColumnDotPlot} class.
Refer to the documentation for each method for more details on the remaining arguments.

For setting up data values:
\itemize{
\item \code{\link{.cacheCommonInfo}(x)} adds a \code{"ColumnDotPlot"} entry containing \code{valid.colData.names}, a character vector of names of columns that are valid (i.e., contain atomic values); \code{discrete.colData.names}, a character vector of names for columns with discrete atomic values; and \code{continuous.colData.names}, a character vector of names of columns with continuous atomic values.
This will also call the equivalent \linkS4class{DotPlot} method.
\item \code{\link{.refineParameters}(x, se)} replaces \code{NA} values in \code{ColorByFeatAssay} with the first valid assay name in \code{se}.
This will also call the equivalent \linkS4class{DotPlot} method.
}

For defining the interface:
\itemize{
\item \code{\link{.hideInterface}(x, field)} returns a logical scalar indicating whether the interface element corresponding to \code{field} should be hidden.
This returns \code{TRUE} for row selection parameters (\code{"RowSelectionSource"} and \code{"RowSelectionRestrict"}),
otherwise it dispatches to the \linkS4class{Panel} method.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for all slots described above and in the parent classes.
This will also call the equivalent \linkS4class{DotPlot} method.
}

For controlling selections:
\itemize{
\item \code{\link{.multiSelectionRestricted}(x)} returns a logical scalar indicating whether \code{x} is restricting the plotted points to those that were selected in a transmitting panel.
\item \code{\link{.multiSelectionDimension}(x)} returns \code{"column"} to indicate that a multiple column selection is being transmitted.
\item \code{\link{.multiSelectionInvalidated}(x)} returns \code{TRUE} if the faceting options use multiple column selections,
such that the point coordinates/domain may change upon updates to upstream selections in transmitting panels.
\item \code{\link{.singleSelectionDimension}(x)} returns \code{"sample"} to indicate that a sample identity is being transmitted.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing the steps of a tour relevant to subclasses,
mostly tuning the more generic descriptions from the same method of the parent \linkS4class{DotPlot}.
\item \code{\link{.getDotPlotColorHelp}(x, color_choices)} returns a data.frame containing the documentation for the \code{"ColorBy"} UI element,
specialized for column-based dot plots.
}

Unless explicitly specialized above, all methods from the parent classes \linkS4class{DotPlot} and \linkS4class{Panel} are also available.
}

\section{Subclass expectations}{

Subclasses are expected to implement methods for, at least:
\itemize{
\item \code{\link{.generateDotPlotData}}
\item \code{\link{.fullName}}
\item \code{\link{.panelColor}}
}

The method for \code{\link{.generateDotPlotData}} should create a \code{plot.data} data.frame with one row per column in the \linkS4class{SummarizedExperiment} object.
}

\seealso{
\linkS4class{DotPlot}, for the immediate parent class that contains the actual slot definitions.
}
\author{
Aaron Lun
}
