% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iES_surv.R
\name{iES_surv}
\alias{iES_surv}
\title{iES calculation Function}
\usage{
iES_surv(iES_mat, cli, indVec = NULL, npatsThre = 5)
}
\arguments{
\item{iES_mat}{is iES matrix with rows corresponding to the pathway and columns corresponding to the patients.}

\item{cli}{clinical data associated to the gene expression data.}

\item{indVec}{binary vector indicating normal (0) and tumor (1).}

\item{npatsThre}{the threshold of number of patients for survival analysis.}
}
\value{
a matrix of survival analysis from coxph.
}
\description{
This function allows to investigate on one specific pathway.
}
\examples{
data(PRAD_data)
data(GSDB_example)
iES_mat = iES_cal2(prad_exprs, GSDB = GSDB_example)
iES_surv(iES_mat, cli = prad_cli, indVec = prad_inds)
}
\keyword{analysis}
\keyword{and}
\keyword{for}
\keyword{groups}
\keyword{iPath}
\keyword{normal-like.}
\keyword{of}
\keyword{patients:}
\keyword{perturbed}
\keyword{survival}
\keyword{two}
