% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fctPartialCors.R
\name{fctPartialCors}
\alias{fctPartialCors}
\title{fctPartialCors}
\usage{
fctPartialCors(loadData, rho = 0.25)
}
\arguments{
\item{loadData}{A prepossessed data matrix resulting from "load data" function.}

\item{rho}{The regularization parameter for lasso. (a non-negative value or a p by p matrix of regularization parameters).}
}
\value{
partial_cor_mat A partial correlation matrix with NA's in the diagonal.
}
\description{
Calculates partial correlations based on graphical lasso (https://www.rdocumentation.org/packages/glassoFast/versions/1.0/topics/glassoFast).
}
\examples{
# Simulate a small expression matrix
set.seed(123)
mat <- matrix(rnorm(100), nrow = 10, ncol = 10)
colnames(mat) <- paste0("Gene", 1:10)
rownames(mat) <- paste0("Sample", 1:10)

# Run partial correlation
partial_cor_matrix <- fctPartialCors(mat, rho = 0.25)

# View a portion of the result
partial_cor_matrix[1:5, 1:5]

}
