% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/create_gene_exp.R
\name{create_gene_exp}
\alias{create_gene_exp}
\title{Create an joint gene expression table of all samples}
\usage{
create_gene_exp(sample_desc, read_fun = NULL, progress = TRUE,
  progress_width = 48, ...)
}
\arguments{
\item{sample_desc}{data.table object created by \link{create_sample_desc}.}

\item{read_fun}{Custom reader function, see its own section for more detail.}

\item{progress}{Whether to display a progress bar. By default \code{TRUE}.}

\item{progress_width}{The text width of the shown progress bar. By default is
48 chars wide.}

\item{...}{Arguments passed to the custom reader function specified in
  \code{read_fun}.}
}
\value{
data.table of all samples gene expression, whose rows are gene
  expression and columns are sample names. First column \code{GENE} contains
  the corresponding gene names.
}
\description{
The function reads in all gene expression data given by the sample
description \code{sample_desc} and return a joint expression table of all
samples.
}
\details{
By default it assumes the data to be of TCGA level 3 file format. However,
nearly all real world data fail to have the same format as TCGA. In this
case, one needs to tell the function how to parse the data by implementing a
custom reader function that accepts the filepath as the first argument. See
Detail section for full specification. The function naively concatenates all
return expression \emph{as if all gene expressions are stated in the same
gene order} as columns in a new data.table.
}
\note{
The function assumes row order for all samples' gene expressions are the
  same.
}
\section{Custom reader function}{
 Custom reader function is given by
  \code{read_fun = your_reader_fun}. It takes the filepath as the first
  argument and return a data.table with the first two columns being
  \code{GENE} and \code{Expression} of type character and double.

  The output joint gene expression table has first column \code{GENE} store
  the gene name, which are are determined by the first sample being
  evaluated.

  Rest arguments of \code{create_gene_exp(...)} will be passed to this reader
  function.

  Note: all string-like columns should \strong{NOT} be of type \code{factor}.
  Remember to set \code{stringsAsFactors = FALSE}.
}
\examples{
## Use first three samples of the builtin dataset

sample_root <- system.file("extdata", package = "iGC")
sample_desc_pth <- file.path(sample_root, "sample_desc.csv")
sample_desc <- create_sample_desc(
    sample_desc_pth, sample_root=sample_root
)[1:3]

## Define custom reader function for TCGA level 3 data
my_gene_exp_reader <- function(ge_filepath) {
    gene_exp <- read.table(
        ge_filepath,
        header = FALSE, skip = 2,
        na.strings = "null",
        colClasses = c("character", "double")
    )
    dt <- data.table::as.data.table(gene_exp)
    data.table::setnames(dt, c("GENE", "Expression"))
}
gene_exp <- create_gene_exp(
    sample_desc,
    read_fun = my_gene_exp_reader,
    progress_width = 60
)
gene_exp[1:5]
}
\seealso{
\code{\link[utils]{read.table}} and \code{\link[data.table]{fread}}
  for custom reader function implementation; \code{\link{create_sample_desc}}
  for creating sample description.
}

