% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COBRAData.R
\name{update_cobradata}
\alias{update_cobradata}
\title{Update \code{COBRAData} object to the current version of the class 
format}
\usage{
update_cobradata(object, quiet = FALSE)
}
\arguments{
\item{object}{A \code{COBRAData} object}

\item{quiet}{Set to TRUE to disable messages listing the modifications that
are applied to the object}
}
\value{
An updated \code{COBRAData} object
}
\description{
Update a \code{COBRAData} object generated by a previous version of the
package to the latest version.
}
\examples{
## Generate COBRAData object
set.seed(123)
pval <- data.frame(m1 = runif(100), m2 = runif(100),
                   row.names = paste0("F", 1:100))
truth <- data.frame(status = round(runif(100)),
                    row.names = paste0("F", 1:100))
cobradata <- COBRAData(pval = pval, truth = truth)

## Update object if needed
cobradata <- update_cobradata(cobradata)
}
\author{
Charlotte Soneson
}
