% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{scatter}
\alias{scatter}
\alias{scatter<-}
\alias{scatter,COBRAPerformance-method}
\alias{scatter<-,COBRAPerformance,data.frame-method}
\alias{scatter,COBRAPlot-method}
\alias{scatter<-,COBRAPlot,data.frame-method}
\title{Accessor and replacement functions for \code{scatter} slot}
\usage{
scatter(x, ...)

scatter(x, ...) <- value

\S4method{scatter}{COBRAPerformance}(x)

\S4method{scatter}{COBRAPerformance,data.frame}(x) <- value

\S4method{scatter}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving information necessary to generate scatter
plots of observed vs true values for each method and each stratification
level.}
}
\value{
The accessor function returns a data frame giving information
  necessary to generate scatter plots of observed vs true values for each
  method and each stratification level.
}
\description{
Accessor and replacement functions for the \code{scatter} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example, cont_truth = "logFC",
                                   aspects = "scatter")
head(scatter(cobraperf))
}
\author{
Charlotte Soneson
}
