% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_performance.R
\name{prepare_data_for_plot}
\alias{prepare_data_for_plot}
\title{Prepare data for plotting}
\usage{
prepare_data_for_plot(
  cobraperf,
  keepmethods = NULL,
  incloverall = TRUE,
  colorscheme = "hue_pal",
  facetted = TRUE,
  incltruth = TRUE,
  conditionalfill = TRUE
)
}
\arguments{
\item{cobraperf}{A \code{COBRAPerformance} object.}

\item{keepmethods}{A character vector consisting of methods to retain for
plotting (these should be a subset of \code{basemethods(cobraperf)}), or
NULL (indicating that all methods represented in cobraperf should be
retained).}

\item{incloverall}{A logical indicating whether the "overall" results should
be included if the results are stratified by an annotation.}

\item{colorscheme}{Either a character string giving the color palette to use
to define colors for the different methods, or a character vector with
colors to use. The available pre-defined palettes depend on the number of
different methods to distinguish. The choices are:
\describe{
\item{- \code{Accent}}{(max 8 methods)}
\item{- \code{Dark2}}{(max 8 methods)}
\item{- \code{Paired}}{(max 12 methods)}
\item{- \code{Pastel1}}{(max 9 methods)}
\item{- \code{Pastel2}}{(max 8 methods)}
\item{- \code{Set1}}{(max 9 methods)}
\item{- \code{Set2}}{(max 8 methods)}
\item{- \code{Set3}}{(max 12 methods)}
\item{- \code{hue_pal}}{}
\item{- \code{rainbow}}{}
\item{- \code{heat}}{}
\item{- \code{terrain}}{}
\item{- \code{topo}}{}
\item{- \code{cm}}{}
}
If the number of allowed methods is exceeded, the colorscheme defaults to
\code{hue_pal}.}

\item{facetted}{A logical indicating whether the results should be split into
subpanels when stratified by an annotation (\code{TRUE}), or kept in the
same panel but shown with different colors (\code{FALSE}).}

\item{incltruth}{A logical indicating whether the truth should be included in
Venn diagrams.}

\item{conditionalfill}{A logical indicating whether the points (in FDR/TPR,
FDR/NBR, FSR/NBR plots) should be filled conditional on whether they
satisfy the imposed criterion (e.g., false discovery rate control at
imposed threshold).}
}
\value{
A \code{COBRAPlot} object
}
\description{
Prepare performance data provided in a \code{COBRAPerformance} object
(obtained by \code{\link{calculate_performance}}) for plotting.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   cont_truth = "none",
                                   aspects = c("fdrtpr", "fdrtprcurve",
                                               "tpr", "roc"),
                                   thrs = c(0.01, 0.05, 0.1), splv = "none")
cobraplot <- prepare_data_for_plot(cobraperf, keepmethods = NULL,
                                   colorscheme = "Dark2")

## User-specified colors
cobraplot2 <- prepare_data_for_plot(cobraperf, keepmethods = NULL,
                                   colorscheme = c("blue", "red", "green"))
}
\author{
Charlotte Soneson
}
