% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_scatter}
\alias{plot_scatter}
\title{Plot scatter plots}
\usage{
plot_scatter(
  cobraplot,
  title = "",
  stripsize = 10,
  titlecol = "black",
  pointsize = 3,
  doflip = FALSE,
  dolog = FALSE
)
}
\arguments{
\item{cobraplot}{A \code{COBRAPlot} object.}

\item{title}{A character string giving the title of the plot.}

\item{stripsize}{A numeric value giving the size of the strip text, when the
results are stratified by an annotation.}

\item{titlecol}{A character string giving the color of the title.}

\item{pointsize}{A numeric value giving the size of the plot characters.}

\item{doflip}{A logical indicating whether to flip the axes when results are
stratified by an annotation. By default (\code{doflip = FALSE}),
stratification levels are shown as columns and methods as rows in the plot.}

\item{dolog}{A logical indicating whether to log10-transform values before
plotting.}
}
\value{
A ggplot object
}
\description{
Plot scatter plots, indicating the relationship between observed values and a
continuous truth.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example, cont_truth = "logFC",
                                   aspects = "scatter")
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2",
                                   incltruth = TRUE)
plot_scatter(cobraplot)
}
\author{
Charlotte Soneson
}
