% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_fsrnbrcurve}
\alias{plot_fsrnbrcurve}
\title{Plot number of features with s-value below threshold vs FSR}
\usage{
plot_fsrnbrcurve(
  cobraplot,
  title = "",
  stripsize = 15,
  titlecol = "black",
  pointsize = 5,
  xaxisrange = c(0, 1),
  plottype = c("curve", "points"),
  linewidth = 1
)
}
\arguments{
\item{cobraplot}{A \code{COBRAPlot} object.}

\item{title}{A character string giving the title of the plot.}

\item{stripsize}{A numeric value giving the size of the strip text, when the
results are stratified by an annotation.}

\item{titlecol}{A character string giving the color of the title.}

\item{pointsize}{A numeric value giving the size of the plot characters.}

\item{xaxisrange}{A numeric vector with two elements, giving the lower and
upper boundary of the x-axis, respectively.}

\item{plottype}{A character vector giving the type of plot to construct. Can
be any combination of the two elements "curve" and "points".}

\item{linewidth}{The line width used for plotting}
}
\value{
A ggplot object
}
\description{
Plot the number of features with an s-value below a threshold vs the observed
false sign rate (FSR), for given adjusted p-value thresholds and/or as curves
traced out by considering all threshold values.
}
\examples{
data(cobradata_example_sval)
cobraperf <- calculate_performance(cobradata_example_sval,
                                   cont_truth = "logFC",
                                   aspects = c("fsrnbr", "fsrnbrcurve"))
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2",
                                   incltruth = TRUE)
plot_fsrnbrcurve(cobraplot, plottype = c("curve", "points"))
}
\author{
Charlotte Soneson
}
