% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{fpr}
\alias{fpr}
\alias{fpr<-}
\alias{fpr,COBRAPerformance-method}
\alias{fpr<-,COBRAPerformance,data.frame-method}
\alias{fpr,COBRAPlot-method}
\alias{fpr<-,COBRAPlot,data.frame-method}
\title{Accessor and replacement functions for \code{fpr} slot}
\usage{
fpr(x, ...)

fpr(x, ...) <- value

\S4method{fpr}{COBRAPerformance}(x)

\S4method{fpr}{COBRAPerformance,data.frame}(x) <- value

\S4method{fpr}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving information about the observed FPR for each
method and each stratification level, at various adjusted p-value
thresholds.}
}
\value{
The accessor function returns a data frame giving information about
  the observed FPR for each method and each stratification level, at various
  adjusted p-value thresholds.
}
\description{
Accessor and replacement functions for the \code{fpr} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status", aspects = "fpr")
head(fpr(cobraperf))
}
\author{
Charlotte Soneson
}
