% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{fdrtprcurve}
\alias{fdrtprcurve}
\alias{fdrtprcurve<-}
\alias{fdrtprcurve,COBRAPerformance-method}
\alias{fdrtprcurve<-,COBRAPerformance,data.frame-method}
\alias{fdrtprcurve,COBRAPlot-method}
\alias{fdrtprcurve<-,COBRAPlot,data.frame-method}
\title{Accessor and replacement functions for \code{fdrtprcurve} slot}
\usage{
fdrtprcurve(x, ...)

fdrtprcurve(x, ...) <- value

\S4method{fdrtprcurve}{COBRAPerformance}(x)

\S4method{fdrtprcurve}{COBRAPerformance,data.frame}(x) <- value

\S4method{fdrtprcurve}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving information necessary to generate curves of
observed FDR vs TPR for each method and each stratification level.}
}
\value{
The accessor function returns a data frame giving information
  necessary to generate curves of observed FDR vs TPR for each method and
  each stratification level.
}
\description{
Accessor and replacement functions for the \code{fdrtprcurve} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrtprcurve")
head(fdrtprcurve(cobraperf))
}
\author{
Charlotte Soneson
}
