% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{fdrnbr}
\alias{fdrnbr}
\alias{fdrnbr<-}
\alias{fdrnbr,COBRAPerformance-method}
\alias{fdrnbr<-,COBRAPerformance,data.frame-method}
\alias{fdrnbr,COBRAPlot-method}
\alias{fdrnbr<-,COBRAPlot,data.frame-method}
\title{Accessor and replacement functions for \code{fdrnbr} slot}
\usage{
fdrnbr(x, ...)

fdrnbr(x, ...) <- value

\S4method{fdrnbr}{COBRAPerformance}(x)

\S4method{fdrnbr}{COBRAPerformance,data.frame}(x) <- value

\S4method{fdrnbr}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving information about the observed FPR and the
number of features called positive for each method and each stratification
level, at various adjusted p-value thresholds.}
}
\value{
The accessor function returns a data frame giving information about
  the observed FPR and the number of features called positive for each method
  and each stratification level, at various adjusted p-value thresholds.
}
\description{
Accessor and replacement functions for the \code{fdrnbr} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrnbr")
head(fdrnbr(cobraperf))
}
\author{
Charlotte Soneson
}
