% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COBRAPlot.R
\docType{methods}
\name{coerce}
\alias{coerce}
\alias{coerce,COBRAPerformance,COBRAPlot-method}
\alias{coerce,}
\alias{COBRAPlot,COBRAPerformance-method}
\alias{coerce,COBRAPlot,COBRAPerformance-method}
\title{Convert an object to another class}
\arguments{
\item{from}{The object that is to be coerced into another class.}
}
\description{
Convert object between \code{COBRAPerformance} and \code{COBRAPlot} classes.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrtpr")
cobraplot <- prepare_data_for_plot(cobraperf)

## Coerce COBRAPerformance object into COBRAPlot object
as(cobraperf, "COBRAPlot")

## Coerce COBRAPlot object into COBRAPerformance object
as(cobraplot, "COBRAPerformance")
}
\author{
Charlotte Soneson
}
