% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R
\docType{methods}
\name{basemethods}
\alias{basemethods}
\alias{basemethods,COBRAPerformance-method}
\alias{basemethods,COBRAPlot-method}
\title{Accessor function for basemethods}
\usage{
basemethods(x, ...)

\S4method{basemethods}{COBRAPerformance}(x)
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}
}
\value{
A character vector of all methods represented in the object.
}
\description{
Accessor function to extract the methods that are represented in an
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrtprcurve")
basemethods(cobraperf)
}
\author{
Charlotte Soneson
}
