% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_by_group.R
\name{mergeByGroup}
\alias{mergeByGroup}
\title{Merge probability matrix based on annotations}
\usage{
mergeByGroup(pm, group_df)
}
\arguments{
\item{pm}{A numeric matrix. Probability matrix generated by the soft_max function.}

\item{group_df}{A character matrix. Annotation of the neighboring cells to be used.}
}
\value{
A probability matrix, describing the probability of each cell being
in each cellular neighborhood.
}
\description{
Merge probability matrix based on annotations
}
\examples{

data("spe_test")

spe <- readHoodData(spe, anno_col = "celltypes")

fnc <- findNearCells(spe, k = 100)

pm <- scanHoods(fnc$distance)

pm2 <- mergeByGroup(pm, fnc$cells)

}
