% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{visualize_report}
\alias{visualize_report}
\title{Visualize a HiPathia report}
\usage{
visualize_report(output_folder, port = 4000)
}
\arguments{
\item{output_folder}{Folder in which results to visualize are stored}

\item{port}{Port to use}
}
\value{
The instructions to visualize a HiPathia report in a web browser
}
\description{
Visualize a HiPathia report
}
\examples{
data(comp)
pathways <- load_pathways(species = "hsa", pathways_list = c("hsa03320",
"hsa04012"))
report <- create_report(comp, pathways, "save_results")
visualize_report(report)

\dontrun{
data(results)
data(brca)
sample_group <- colData(brca)[,1]
colors_de <- node_color_per_de(results, pathways,
sample_group, "Tumor", "Normal")
report <- create_report(comp, pathways, "save_results",
node_colors = colors_de)
visualize_report(report)
visualize_report(report, port = 5000)
}
\dontshow{servr::daemon_stop()}

}
