% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{translate_data}
\alias{translate_data}
\title{Translation of the rownames IDs of a SummarizedExperiment to Entrez IDs.}
\usage{
translate_data(data, species, sel_assay = 1, verbose = TRUE)
}
\arguments{
\item{data}{Either a SummarizedExperiment object or a matrix of gene
expression.}

\item{species}{Species of the samples.}

\item{sel_assay}{Character or integer, indicating the assay to be translated
in the SummarizedExperiment. Default is 1.}

\item{verbose}{Boolean, whether to show details about the results of the
execution.}
}
\value{
Either a SummarizedExperiment or a matrix (depending on the input
type) of gene expression with Entrez IDs as rownames.
}
\description{
Translates the IDs in the rownames of a SummarizedExperiment to Entrez IDs.
For accepted IDs to be transformed see the DOCUMENTATION.
}
\examples{
data("brca_data")
trans_data <- translate_data(brca_data, "hsa")

}
