% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{save_results}
\alias{save_results}
\title{Save results to folder}
\usage{
save_results(results, comp, metaginfo, output_folder = NULL, path = NULL)
}
\arguments{
\item{results}{Results object as returned by the \code{hipathia} function.}

\item{comp}{Comparison as returned by the \code{do_wilcoxon} function.}

\item{metaginfo}{Pathways object}

\item{output_folder}{Name of the folder in which the results will be stored.}

\item{path}{Absolute path to the parent directory in which `output_folder`
will be saved. If it is not provided, it will be created in a temp folder.}
}
\value{
Creates a folder in disk in which all the information to browse the
pathway results is stored.
}
\description{
Saves results to a folder. In particular, it saves the matrix of subpathway
values, a table with the results of the provided comparison,
the accuracy of the results and the .SIF and attributes of the pathways.
}
\examples{
data(results)
data(comp)
pathways <- load_pathways(species = "hsa", pathways_list = c("hsa03320",
"hsa04012"))
save_results(results, comp, pathways, "output_results")

}
