% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{quantify_terms}
\alias{quantify_terms}
\title{Computes the level of activation of the functions related to the
previously computed subpathways}
\usage{
quantify_terms(
  results,
  metaginfo,
  dbannot,
  out_matrix = FALSE,
  normalize = TRUE
)
}
\arguments{
\item{results}{List of results as returned by the \code{hipathia} function}

\item{metaginfo}{Pathways object}

\item{dbannot}{Either a string indicating which precomputed annotation to
use ("uniprot" for Uniprot Keywords or "GO" for Gene Ontology terms), or
a dataframe with the annotation of the genes to the functions. First
column are gene symbols, second column the functions.}

\item{out_matrix}{Boolean, whther the output object should be a matrix
object. Default is FALSE, returning a SummarizedExperiment object.}

\item{normalize}{Boolean, whether to normalize the matrix of pathway
values with \code{normalize_paths} before quantifying the signal. Due to
the nature of the Hipathia method, in which the length of each pathway may
alter its signal rank, we strongly recommend to perform this normalization.
This normalization removes the bias. Default is set to TRUE.}
}
\value{
Matrix with the level of activation of the functions in
\code{dbannot}
}
\description{
Computes the level of activation of the functions related to the
previously computed subpathways
}
\examples{
data(results)
pathways <- load_pathways(species = "hsa", pathways_list = c("hsa03320",
"hsa04012"))
go_values <- quantify_terms(results, pathways, "GO")
uniprot_values <- quantify_terms(results, pathways, "uniprot")

}
