% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart.R
\name{pca_plot}
\alias{pca_plot}
\title{Plots two components of a PCA}
\usage{
pca_plot(
  fit,
  group = NULL,
  sample_colors = NULL,
  cp1 = 1,
  cp2 = 2,
  legend = TRUE,
  legend_xy = "bottomleft",
  cex = 2,
  pch = 20,
  mgp = c(3, 1, 0),
  main = "PCA plot",
  save_png = NULL
)
}
\arguments{
\item{fit}{princomp object as returned by \code{do_pca}}

\item{group}{Vector with the group to which each sample belongs.
The samples must be ordered as in \code{rownames(fit$scores)}.
By default, all samples will be assigned to the same class.}

\item{sample_colors}{Named character vector of colors. The names of
the colors must be the classes in \code{group}. Each sample will be
assigned the color corresponding to its class, taken from the
\code{group} vector. By default a color will be assigned
automatically to each class.}

\item{cp1}{Integer, number of the component in the X-axis.
Default is 1, the first component.}

\item{cp2}{Integer, number of the component in the Y-axis.
Default is 2, the second component.}

\item{legend}{Boolean, whether to plot a legend in the plot.
Default is TRUE.}

\item{legend_xy}{Situation of the legend in the plot. Available
options are: "bottomright", "bottom", "bottomleft", "left",
"topleft", "top", "topright", "right" and "center".}

\item{cex}{Graphical parameter from \code{par()} function.}

\item{pch}{Graphical parameter from \code{par()} function.}

\item{mgp}{Graphical parameter from \code{par()} function.}

\item{main}{Title of the graphics}

\item{save_png}{Path to the file where the image as PNG will be saved.
By default, the image is not saved.}
}
\value{
Plots two components of a PCA
}
\description{
Plots two components of a PCA computed with \code{do_pca}
}
\examples{
data(path_vals)
sample_group <- brca_design[colnames(path_vals),"group"]
pca_model <- do_pca(path_vals[seq_len(ncol(path_vals)),])
pca_plot(pca_model, sample_group)

}
