% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart.R
\name{pathway_comparison_plot}
\alias{pathway_comparison_plot}
\title{Plots pathway with colored significant paths}
\usage{
pathway_comparison_plot(
  comp,
  metaginfo,
  pathway,
  conf = 0.05,
  node_colors = NULL,
  colors = "classic"
)
}
\arguments{
\item{comp}{Comparison data frame as returned by the \code{do_wilcox}
function.}

\item{metaginfo}{Pathways object.}

\item{pathway}{Name of the pathway to be plotted.}

\item{conf}{Level of significance of the comparison for the adjusted
p-value. Default is 0.05.}

\item{node_colors}{List, named by the pathway name, including the
color of each node for each pathway.}

\item{colors}{Either a character vector with 3 colors (indicating,
in this order, down-regulation, non-significance and up-regulation colors)
or a key name indicating the color scheme to be used. Options are:}
}
\value{
Image in which a pathway is ploted. Edges are colored so that the
UP- and DOWN-activated subpathways are identified.
}
\description{
Plots the layout of a pathway, coloring the significant subpathways
in different colors depending on whether they are significantly up- or
down-regulated. Nodes may be also colored providing a suitable list of
colors for each node. Function \code{node_color_per_de}
assigns colors to the nodes depending on their differential expression.
}
\section{Slots}{

\describe{
\item{\code{classic}}{ColorBrewer blue, white and colorBrewer red.}

\item{\code{hipathia}}{Hipathia predefined color scheme: Green, white and orange.
By default \code{classic} color scheme is applied.}
}}

\examples{
data(comp)
pathways_list <- c("hsa03320", "hsa04012")
pathways <- load_pathways(species = "hsa", pathways_list)
pathway_comparison_plot(comp, metaginfo = pathways, pathway = "hsa03320")

\dontrun{
data(results)
data(brca)
colors_de <- node_color_per_de(results, pathways, group, "Tumor", "Normal")
pathway_comparison_plot(comp, metaginfo = pathways, pathway = "hsa04012",
node_colors = colors_de)
}

}
