% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{paths_to_go_ancestor}
\alias{paths_to_go_ancestor}
\title{Create path results table with highest significant GO ancestors}
\usage{
paths_to_go_ancestor(pathways, comp_paths, comp_go, pval = 0.05)
}
\arguments{
\item{pathways}{Pathways object}

\item{comp_paths}{Wilcoxon comparison of the matrix of pathways values
as returned by \code{do_wilcoxon}.}

\item{comp_go}{Wilcoxon comparison of the matrix of GO values as
returned by \code{do_wilcoxon}.}

\item{pval}{P-value cut-off. Default values is set to 0.05.}
}
\value{
Table of comparisons with Highest common ancestors
}
\description{
Create table of results with the comparison of the paths together with
the GO functional annotation and the highest significant GO ancestor
(HSGOA).
}
\details{
The table returns in each row: the name of a pathway and its Wilcoxon
comparison information (direction, adjusted p-value), the GO term to which
the path is related (not necessarily unique), the Wilcoxon comparison
informationfor this GO (direction, adjusted p-value), the HSGOA of this
GO and its Wilcoxon comparison information (direction, adjusted p-value).

The HSGOA is computed as the GO term with minimum level from all the
significant (with respect to value \code{pval}) ancestors of a GO.
The level of a GO term is computed as the number of nodes in the shortest
path from this GO term to the term "GO:0008150". The ancestors of a node
are defined as all the nodes from which a path can be defined from the
ancestor to the node.
}
\examples{
data(comp)
data(go_vals)
data(brca_design)
data(path_vals)
sample_group <- brca_design[colnames(path_vals),"group"]
comp_go <- do_wilcoxon(go_vals, sample_group, g1 = "Tumor", g2 = "Normal")
\dontrun{pathways <- load_pathways(species = "hsa", pathways_list =
c("hsa03320", "hsa04012"))
table <- paths_to_go_ancestor(pathways, comp, comp_go)}

}
